/*
 * Header for the watch functions program.
 *
 * Copyright 2025-2026 Andrew Wood
 *
 * License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>.
 */

#ifndef WATCH_H
#define WATCH_H 1

#define MAX_EXCLUDES 1000

#ifndef _STDDEF_H
#include <stddef.h>
#endif  /* _STDDEF_H */

typedef /*@only@ */ char *excluded_string_t;
typedef /*@only@ */ const char *toplevel_path_t;

struct watch_dir_params_s {
	toplevel_path_t *toplevel_paths;
	size_t toplevel_path_count;
	const char *changedpath_dir;
	const /*@null@ */ char *exchange_dir;
	const /*@null@ */ char *exchange_identity;
	const /*@null@ */ char *metrics_file;
	unsigned long full_scan_interval;
	unsigned long queue_run_interval;
	unsigned long queue_run_max_seconds;
	unsigned long changedpath_dump_interval;
	unsigned long exchange_interval;
	unsigned int max_dir_depth;
	excluded_string_t excludes[MAX_EXCLUDES];
	size_t exclude_count;
	/*@null@ */ char *changefile_suffix;
	bool null_delimiter;
	bool absolute_paths;
	bool only_list_files;
	bool only_list_directories;
	bool no_file_tracking;
};

/*@-exportlocal@*/
int watch_dir(struct watch_dir_params_s *);

bool validate_exchange_identity(const char *);
/*@+exportlocal@*/

#endif				/* WATCH_H */
