/*
 * Header for the sync program.
 *
 * Copyright 2014, 2021, 2023, 2025-2026 Andrew Wood
 *
 * License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>.
 */

#ifndef SYNC_H
#define SYNC_H 1

#define DEFAULT_CONFIG_FILE SYSCONFDIR "/continual-sync.conf"
#define DEFAULTS_SECTION "defaults"
#define MAX_CONFIG_SECTIONS 1000
#define MAX_EXCLUDES 1000

#include <signal.h>

/*
 * Structure describing a synchronisation set.
 */
struct sync_set_s {
	char *name;
	nullable_string source;
	nullable_string destination;
	char *excludes[MAX_EXCLUDES];
	int exclude_count;
	nullable_string source_validation;
	nullable_string destination_validation;
	unsigned long full_interval;
	unsigned long full_retry;
	unsigned long full_timeout;
	unsigned long partial_interval;
	unsigned long partial_retry;
	unsigned long partial_timeout;
	unsigned long recursion_depth;
	nullable_string full_marker;
	nullable_string partial_marker;
	nullable_string change_queue;
	nullable_string transfer_list;
	nullable_string tempdir;
	nullable_string sync_lock;
	nullable_string full_rsync_opts;
	nullable_string partial_rsync_opts;
	bool ignore_vanished_files;
	bool track_files;
	nullable_string log_file;
	nullable_string status_file;
	nullable_string section_list_file;
	bool selected;			 /* set if selected on cmd line */
	pid_t pid;			 /* pid of sync process or 0 */
	/*
	 * These flags are set by the config parser if the parameters they
	 * are named for were explicitly set in this section, so we know
	 * which ones to override from the DEFAULTS_SECTION section on
	 * validation.
	 */
	struct {
		bool full_interval;
		bool full_retry;
		bool full_timeout;
		bool partial_interval;
		bool partial_retry;
		bool partial_timeout;
		bool recursion_depth;
		bool ignore_vanished_files;
		bool track_files;
	} set;
};

extern bool sync_exit_now;		 /* exit-now flag (on signal) */

void continual_sync(struct sync_set_s *, bool);

#endif	/* SYNC_H */
