# NAME

continual-sync - keep duplicates of directory trees in sync

# SYNOPSIS

**continual-sync** \[*OPTION\...*\] \[*SECTION\...*\]\
**continual-sync** \[*-h*\|*-V*\]

# DESCRIPTION

**continual-sync** synchronises one directory tree with another, using
**rsync**(1), and efficiently keeps it up to date by using
**watchdir**(1) to watch for changes and then re-running **rsync** on
only those files and directories which have changed.

It can be used to mirror directories between machines automatically, for
instance backing up your local files to an off-site file server.

One synchronisation process is spawned for every *SECTION* listed on the
command line. If none are listed, then a process is spawned for every
section defined by the configuration files (except the special
"**defaults**" section).

Some example configuration files, and monitoring templates and scripts,
are included with the documentation of this package, such as under
*/usr/share/doc/continual-sync-0.9.0/*.

# OPTIONS

**-c**, **\--config FILE**

:   Read configuration details from *FILE* instead of the default
    */etc/continual-sync.conf*.

    This option can be specified multiple times to read multiple
    configuration files, or you can use the **include** directive within
    a file - see **continual-sync.conf**(5).

**-D**, **\--daemon PIDFILE**

:   Run as a daemon (detach from the controlling terminal and run in the
    background), and write the daemon\'s process ID to *PIDFILE*.

**-h, \--help**

:   Print a usage message on standard output and exit successfully.

**-V, \--version**

:   Print version information on standard output and exit successfully.

# NOTES

Changes involving files or directories which are not readable will not
be picked up by a partial sync, and may result in synchronisations
failing.

Changes which do not modify the contents of a file - for example,
changing permissions - are not picked up by a partial sync.

As with **watchdir**(1), when source directories have a large number of
subdirectories, changes may not start being detected in all of them for
a few minutes. It will also take longer for **continual-sync** to
terminate, as it closes down all of its open watches.

## System tuning

If you watch a lot of directories, you will probably need to increase
the kernel parameter *fs.inotify.max_user_watches*, for example:

sysctl -w fs.inotify.max_user_watches=1048576

You may also need to increase *fs.inotify.max_user_instances* if
**continual-sync** has several configuration sections or there are
multiple instances of it running on the same system.

# REPORTING BUGS

Report bugs in **continual-sync** to [the project\'s issue
tracker](https://codeberg.org/ivarch/continual-sync/issues) or use the
contact form linked from [the project\'s home
page](http://ivarch.com/p/continual-sync).

# SEE ALSO

**continual-sync.conf**(5), **watchdir**(1), **rsync**(1),
**lsyncd**(1), **rsync-inotify**(1), **inosync**(1)

# COPYRIGHT

Copyright © 2014, 2021, 2023, 2025-2026 Andrew Wood.

License GPLv3+: [GNU GPL version 3 or
later](https://www.gnu.org/licenses/gpl-3.0.html).

This is free software: you are free to change and redistribute it. There
is NO WARRANTY, to the extent permitted by law.

Please see the package\'s ACKNOWLEDGEMENTS file for a complete list of
contributors.
