#!/bin/sh
#
# Set up the environment variables, temporary working files, and cleanup
# processes required to run each test.
#
# Tests must exit with 0 for success, 1 for failure, 77 to skip the test, or
# 99 for a fatal error with the test framework.

# Parameters.
testSubject="./scw"
sourcePath="${srcdir?:not set - call this from 'make check'}"
true "${f:?not set - expecting test script filename - call this from 'make check'}"

# Set everything to the "C" locale.
LANG=C
LC_ALL=C
export LANG LC_ALL

# Temporary working area and files, for the test scripts to use.
workDir=$(mktemp -d 2>/dev/null) || { workDir="./.test-tmp"; mkdir -p "${workDir}"; }

# Clean up the temporary files on exit, in case we are interrupted.
trap 'rm -rf "${workDir}"' EXIT

# Show the operator that the test has begun.
test -t 2 && printf '%s: %s\r' '----' "$f" 1>&2

# Count the sub-tests if on a terminal.
subTestCount=""
test -t 2 && subTestCount=$(awk -F = 'BEGIN {max=0} $1=="thisSubTest" {if ($2>max) max=$2} END{print max}' "${srcdir}/$f")

configFile="${workDir}/default.cf"

currentUser="$(id -un)"

configDir="${workDir}/config"
itemsDir="${workDir}/items/${currentUser}"
metricsDir="${workDir}/metrics/${currentUser}"
logsDir="${workDir}/logs/${currentUser}"
mkdir -p "${itemsDir}" "${metricsDir}" "${logsDir}"

{
printf "%s = %s\n" "ItemsDir" "${workDir}/items/{USER}"
printf "%s = %s\n" "MetricsDir" "${workDir}/metrics/{USER}/{ITEM}"
printf "%s = %s\n" "CheckLockFile" "${workDir}/metrics/{USER}/.lock"
printf "%s = %s\n" "Sendmail" "/usr/sbin/sendmail -FCronDaemon -i -odi -oem -oi -t"
printf "%s = %s\n" "UserConfigFile" "${workDir}/config/{USER}.cf"
printf "%s = %s\n" "ItemListFile" "${workDir}/items.json"
printf "%s = %s\n" "CrontabFile" "${workDir}/crontab"
printf "%s = %s\n" "UpdateLockFile" "${workDir}/.update-lock"
printf "%s = %s\n" "OutputMap" "OES stamped ${workDir}/logs/{USER}/{ITEM}.log"
} > "${configFile}"

cat > "${itemsDir}/allsettings.cf" <<EOF
Description = An item that sets all settings
Command = true
AmbiguousExitStatus = 75
Schedule = * * * * Mon-Fri
Schedule = */5 * * * Sat
Schedule = */20 8-17 * * Sun
RandomDelay = 2
MaxRunTime = 1 minute 2 seconds
Prerequisite = true
SuccessInterval = 1 week
ConcurrencyWait = 15
SilentConcurrency = yes
IgnoreOverrun = no
DependencyWait = 2
SilentDependency = no
ConflictWait = 5
SilentConflict = no
StatusMode = fd
StatusTag = Status:
TimestampUTC = no
HTTPInterval = 2
HTTPTimeout = 20
SharedSecret = 
EmailMaxBodySize = unlimited
EmailBodyText = The output is attached.
EmailAttachmentName = output.txt
EmailSender = "(Cron Daemon)" <{USER}>
EmailSubject = Cron <{USER}@{HOSTNAME}> {COMMAND}
OutputMap =
OutputMap = OES stamped ${logsDir}/{ITEM}.log
EOF

cat > "${itemsDir}/item2.cf" <<EOF
Description = A second item.
Command = true
EOF

cat > "${itemsDir}/item3.cf" <<EOF
Description = A third item.
Command = sleep 1
EOF

cat > "${itemsDir}/fail.cf" <<EOF
Description = An item that always fails.
Schedule = 0 10 * * Thu
Command = false
EOF

# Variables used by the test scripts.
export f subTestCount testSubject sourcePath workDir configFile configDir itemsDir metricsDir logsDir
