/*
 * Get the size of the terminal.
 *
 * Copyright 2024-2025 Andrew Wood
 *
 * License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
 */

#include "scw-internal.h"
#include <string.h>
#include <unistd.h>
#if defined(HAVE_SYS_IOCTL_H)
#include <sys/ioctl.h>
#endif


/*
 * Fill in *columns and *rows with the size of the terminal associated with
 * "stream", if possible.  Returns true if values were read.
 */
bool readTerminalSize(FILE * stream, /*@null@ */ unsigned int *columns, /*@null@ */ unsigned int *rows)
{
#ifdef TIOCGWINSZ
	struct winsize wsz;
#endif

	if (NULL == stream)
		return false;

#ifdef TIOCGWINSZ
	memset(&wsz, 0, sizeof(wsz));

	if (0 != isatty(fileno(stream))) {
		if (0 == ioctl(fileno(stream), TIOCGWINSZ, &wsz)) {
			if (NULL != columns)
				*columns = wsz.ws_col;
			if (NULL != rows)
				*rows = wsz.ws_row;
			return true;
		}
	}
#endif
	return false;
}
