#!/bin/sh
#
# Local Checkmk (checkmk.com) script to raise the alarm about SCW items.
#
# Place this in your Checkmk local library directory and make it executable. 
# An example filename would be: /usr/lib/check_mk_agent/local/scw

# The name of the service being reported to Checkmk.
service='scw'

if ! command -v scw >/dev/null 2>&1; then
	printf '%d %s - %s\n' 3 "${service}" 'no scw command found'
	exit 0
fi

workDir="$(mktemp -d)" || { printf '%d %s - %s\n' 3 "${service}" 'failed to create temporary directory'; exit 0; }
if test -z "${workDir}"; then
	printf '%d %s - %s\n' 3 "${service}" 'failed to create temporary directory'
	exit 0
fi
trap 'rm -rf "${workDir}"' EXIT

scw faults --all-users >"${workDir}/out" 2>"${workDir}/err"
rc="$?"
if ! test "${rc}" -eq 0; then
	printf '%d %s - %s (%d)\n' 3 "${service}" 'unexpected scw exit status' "${rc}"
	exit 0
fi

statusCode=0
statusMessage='OK'
if test -s "${workDir}/err"; then
	statusCode=2
	statusMessage='Errors present: '
elif test -s "${workDir}/out"; then
	statusCode=1
	statusMessage='Warnings present: '
fi

extraInfo="$(grep -hE . "${workDir}/err" "${workDir}/out" | tr '\n' ';' | sed -e 's,;$,,' -e 's,;,; ,g')"

printf '%d %s - %s%s\n' ${statusCode} "${service}" "${statusMessage}" "${extraInfo}"

exit 0
