#!/bin/sh
#
# Set up the environment variables, temporary working files, and cleanup
# processes required to run each test.
#
# Tests must exit with 0 for success, 1 for failure, 77 to skip the test, or
# 99 for a fatal error with the test framework.

sourcePath="${srcdir?:not set - call this from 'make check'}"
true "${f:?not set - expecting test script filename - call this from 'make check'}"

# Set everything to the "C" locale.
LANG=C
LC_ALL=C
export LANG LC_ALL

# Temporary working area and files, for the test scripts to use.
workDir=$(mktemp -d 2>/dev/null) || { workDir="./.test-tmp"; mkdir -p "${workDir}"; }

# Clean up the temporary files on exit, in case we are interrupted.
trap 'rm -rf "${workDir}"' EXIT

# Show the operator that the test has begun.
test -t 2 && printf '%s: %s\r' '----' "$f" 1>&2

# Variables used by the test scripts.
export sourcePath f workDir
