# Introduction

This is the README for **continual-sync**, a tool to keep a directory
synchronised with its mirror.  It uses the *inotify* change notification
mechanism to efficiently trigger calls to `rsync`, only including the
relevant paths in each call.

It can be used to mirror directories between machines asynchronously, for
instance backing up your local files to an off-site file server, with
minimal overhead.


# Documentation

Manual pages are included in this distribution.  Use the "`man`" command
after installation to view the manuals for
[continual-sync](docs/continual-sync.8.md),
[watchdir](docs/watchdir.1.md), and
[continual-sync.conf](docs/continual-sync.conf.5.md).

Changes are listed in "[docs/NEWS.md](./docs/NEWS.md)".

Developers and other contributors, please see "[docs/DEVELOPERS.md](./docs/DEVELOPERS.md)".


# Installation

See "[docs/INSTALL](./docs/INSTALL)" for more about the _configure_ script.

The typical process for a system-wide install is:

    sh ./configure --prefix=/usr
    make
    sudo make install

This requires the build toolchain ("`sudo apt install build-essential`" on
Debian or Ubuntu systems).

If this is not a packaged release, the _configure_ script is not included.
It is generated with the GNU build system tools (_autoconf_, _aclocal_,
_autopoint_, _automake_); _gettext_ is also needed.  On Debian or Ubuntu,
run "`sudo apt install automake autopoint gettext`".  Once those tools are
in place, call "`autoreconf -is`" to generate the _configure_ script, and
run it as described above.


# Developers and translators

Developers and translators, please see "[docs/DEVELOPERS.md](./docs/DEVELOPERS.md)".

Translators can use the Weblate instance hosted by Codeberg:
[https://translate.codeberg.org/engage/continual-sync/](https://translate.codeberg.org/engage/continual-sync/)

[![Translation status](https://translate.codeberg.org/widget/continual-sync/multi-auto.svg)](https://translate.codeberg.org/engage/continual-sync/)

If you don't see your language listed, raise an issue on the issue tracker
(or just email the maintainer) asking for it to be added.


# Copyright and bug reporting

See "[docs/ACKNOWLEDGEMENTS.md](./docs/ACKNOWLEDGEMENTS.md)" for a list of
contributors.

Copyright (C) 2014, 2021, 2023, 2025 Andrew Wood.

License GPLv3+: GNU GPL version 3 or later <https://www.gnu.org/licenses/gpl-3.0.html>.

This package is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option)
any later version.

This package is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License, version
3, in "[docs/COPYING](./docs/COPYING)".  If not, see
<https://www.gnu.org/licenses/gpl-3.0.html>.

Please report bugs or request features via the issue tracker linked from the
home page.

The **continual-sync** home page is at:

> [https://ivarch.com/p/continual-sync](https://ivarch.com/p/continual-sync)

The latest version can always be found here.

---
