#!/bin/sh
#
# Functions for an interactive menu.
#
# Copyright 2025 Andrew Wood
#
# License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
#

# TODO.  Note that this section is not yet used.

# Update ttyRows and ttyCols with the current terminal dimensions.
getTerminalSize () {
	if ! test -n "${getTerminalSizeHasRun}"; then
		getTerminalSizeHasRun=1
		getTerminalSizeNeeded=1
		trap 'getTerminalSizeNeeded=1' WINCH
	fi
	test -n "${getTerminalSizeNeeded}" || return
	getTerminalSizeNeeded=0
	ttyInfo="$(LC_ALL=C stty -a | tr '\n' ' ')"
	ttyRows="${ttyInfo##* rows }"
	ttyRows="${ttyRows%%;*}"
	ttyCols="${ttyInfo##* columns }"
	ttyCols="${ttyCols%%;*}"
}


menuHeader () {

	# TODO: prefix with numbers for menu items
	headerLabels='Package archive|Repository collection|Pinned|Included|Outdated|Package|Repository|Target OS'
	headerValues="${sourcePath}|${destinationPath}|${filterPinned}|${filterIncluded}|${filterOutdated}|${filterPackage}|${filterRepository}|${filterTarget}"

	headerLabelMaxWidth="$(printf '%s\n' "${headerLabels}" | tr '|' '\n' | wc -L)"

	getTerminalSize

	# -3 for ": " and one remaining space at the right edge.
	# Another -4 for "nn) ".
	headerValueMaxWidth=$((ttyCols-headerLabelMaxWidth-3-4))
	test "${headerValueMaxWidth}" -gt 1 || headerValueMaxWidth="${ttyCols}"

	headerCount=0
	while test -n "${headerLabels}"; do
		headerLabel="${headerLabels%%|*}"
		headerValue="${headerValues%%|*}"
		headerLabels="${headerLabels#*|}"
		test "${headerLabels}" = "${headerLabel}" && headerLabels=""
		headerValues="${headerValues#*|}"
		test "${headerValues}" = "${headerValue}" && headerValues=""

		if ! test -n "${headerLabel}"; then
			printf '\n'
			continue
		fi

# TODO: colours / highlighting
		headerCount=$((1+headerCount))
		printf "%2d) %${headerLabelMaxWidth}s: %-${headerValueMaxWidth}s\n" "${headerCount}" "${headerLabel}" "${headerValue}"
	done
}


repositoryManagementMenu () {

	filterPinned=''
	filterIncluded=''
	filterOutdated=''
	filterPackage=''
	filterRepository=''
	filterTarget=''

	getTerminalSize

	while true; do
break
# TODO: show header
# TODO: show filter results
# TODO: allow filters to be changed
# TODO: actions menu to operate on results
	done
}
