#!/bin/sh
#
# Functions common to build instructions extraction from source.
#
# Copyright 2025 Andrew Wood
#
# License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
#

# Attempt to find build instructions for Debian from the extracted sources
# under $1, and place them in the directory $2.
#
extractInstructionsForDebian () {
	sourceDir="$1"
	instructionsDir="$2"

	find "${sourceDir}" -type d -name 'debian' | {
	while read -r debianDirPath; do
		test -f "${debianDirPath}/control" || continue
		test -f "${debianDirPath}/rules" || continue
		test -f "${debianDirPath}/changelog" || continue
		cp "${debianDirPath}/"* "${instructionsDir}/"
		break
	done
	}
}

# Attempt to find build instructions for an RPM from the extracted sources
# under $1, and place them in the directory $2.
#
extractInstructionsForRPM () {
	sourceDir="$1"
	instructionsDir="$2"

	specFile="$(find "${sourceDir}" -type f -name '*.spec' | sed -n 1p)"
	test -n "${specFile}" && cp "${specFile}" "${instructionsDir}/rpm.spec"
}
