# Introduction

The package and repository maintenance operator, **parmo**, is a tool to
build software from source, turn it into native operating system packages,
and manage repositories of those packages.

Use **parmo** to build internal repositories of local software, for example
packaging the software used by your organisation for quick deployment using
standard commands like "`apt install`" and "`dnf update`".

 * Build packages from source, for multiple target operating systems, and
   store them in a package archive.

 * Select which version of each package is included in each local
   repository.

 * Index each local repository so that internal systems can use them.

Target operating systems supported:

 * Debian 11-12 (compatible with Ubuntu and others)
 * AlmaLinux 8-9 (compatible with Rocky Linux and others)
 * CentOS 7

Packaging types supported:

 * `.deb` - Debian, Ubuntu, Devuan, anything that uses **apt**
 * `.rpm` - AlmaLinux, SUSE, Rocky, CentOS, RHEL - **dnf**, **yum**, **zypper**

Using Docker or Podman, **parmo** can support multiple operating systems on
a single host.  It automatically maintains build environment containers for
each target.  Alternatively, **parmo** can run in native mode without
containers, supporting only the operating system it is running on.


# Documentation

A manual page is included in this distribution ("`man parmo`").  Before
installation, it is in "[docs/parmo.1](./docs/parmo.1.md)".

Changes are listed in "[docs/NEWS.md](./docs/NEWS.md)".

Developers and translators, please see
"[docs/DEVELOPERS.md](./docs/DEVELOPERS.md)".


# Installation

See "[docs/INSTALL](./docs/INSTALL)" for more about the _configure_ script.

The typical process for a system-wide install is:

    sh ./configure --prefix=/usr
    make
    sudo make install

This requires Make ("`sudo apt install make`" on Debian or Ubuntu systems).

If this is not a packaged release, the _configure_ script is not included. 
It is generated with the GNU build system tools (_autoconf_, _aclocal_,
_automake_).  On Debian or Ubuntu, run "`sudo apt install automake`".  Once
those tools are in place, call "`autoreconf -is`" to generate the
_configure_ script, and run it as described above.


# Copyright, bug reporting, and acknowledgements

Copyright (C) 2025 Andrew Wood.

License GPLv3+: GNU GPL version 3 or later <https://www.gnu.org/licenses/gpl-3.0.html>.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option)
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License, version
3, in "[docs/COPYING](./docs/COPYING)".  If not, see
<https://www.gnu.org/licenses/gpl-3.0.html>.

Please report bugs or request features via the issue tracker linked from the
home page.

The **parmo** home page is at:

> [https://ivarch.com/programs/parmo.shtml](https://ivarch.com/programs/parmo.shtml)

The latest version can always be found here.

---
