Summary: A small utility for digitally signing images.
Name: imagesign
Version: 0.1.0
Release: 1
Copyright: Artistic
Group: Development/Tools
Source: http://www.ivarch.com/programs/sources/imagesign-0.1.0.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root

%description
If you or your organisation regularly produce images and you need to be able
to tell later on whether an image has been modified from the original, or
you need to be able to pass the images on to other people and they need to
be able to check whether it really is you who sent them the image, then this
utility may be useful to you.

It works by digitally signing the image itself (not including any comment
blocks) using `gpg', and then embeds that signature in the image within a
comment block.  This comment block does not affect the image in any way.

Once the image has had a signature embedded in it, you can send it, store
it, or whatever, treating it as you normally would.  However, as soon as the
image is modified in any way (even if it is just loaded and saved again),
the signature will no longer be valid and `imagesign --verify' will tell you
that the image is not the original that you signed.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" sh ./configure \
  --prefix=/usr \
  --infodir=/usr/share/info \
  --mandir=/usr/share/man \
  --sysconfdir=/etc
make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"
[ -e "$RPM_BUILD_ROOT" ] || mkdir -m 755 "$RPM_BUILD_ROOT"
[ -e "$RPM_BUILD_ROOT/etc" ] || mkdir -m 755 "$RPM_BUILD_ROOT/etc"
[ -e "$RPM_BUILD_ROOT/usr" ] || mkdir -m 755 "$RPM_BUILD_ROOT/usr"
[ -e "$RPM_BUILD_ROOT/usr/bin" ] || mkdir -m 755 "$RPM_BUILD_ROOT/usr/bin"
[ -e "$RPM_BUILD_ROOT/usr/share" ] || mkdir -m 755 "$RPM_BUILD_ROOT/usr/share"
[ -e "$RPM_BUILD_ROOT/usr/share/man" ] || mkdir -m 755 "$RPM_BUILD_ROOT/usr/share/man"
[ -e "$RPM_BUILD_ROOT/usr/share/man/man1" ] || mkdir -m 755 "$RPM_BUILD_ROOT/usr/share/man/man1"
make install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"

%pre

%post

%preun

%postun

%files
%defattr(-, root, root)
/usr/bin/*
%doc README doc/NEWS doc/TODO doc/COPYING
%docdir /usr/share/man/man1
/usr/share/man/man1/*

%changelog
* Sat Nov 09 2002 Andrew Wood <andrew.wood@ivarch.com>
- first draft of spec file created
